using Oscar

using Dates, Printf, Statistics
using SQLite, DBInterface, DataFrames
"""
This function can be called, e.g., via:

`
prestore_all_subgroups("~/prestorage_subgroups_n_geq8.sqlite", 8:8, [48, 36, 24, 18, 16, 12, 9, 8, 6, 4, 3, 2, 1],  "left")
prestore_all_subgroups("~/prestorage_subgroups_n_geq8.sqlite", [8,5,6], [[48, 36, 24, 18, 16, 12, 9, 8, 6, 4, 3, 2, 1], [60, 30, 20, 15, 12, 10, 6, 5, 4, 3, 2, 1], [60, 30, 20, 15, 12, 10, 6, 5, 4, 3, 2, 1]],  "left")
`

INFO: useful safety-check for duplicates:
`select * from sg where subgroup_as_tuplelist in (select subgroup_as_tuplelist from sg group by subgroup_as_tuplelist having count(*) > 1)`



"""
function prestore_all_subgroups(filename_of_db, range_of_alphabetsizes, ordersconsidered, left_right_or_both="left")
    function check_right_dimensionality(L, n)
        for cc in L
            for grp in cc
                for perm in grp
                    if length(perm) != n
                        return false
                    end
                end
            end
        end
        return true
    end

    if isfile(filename_of_db)
        timestamp = Dates.now()
        formatted_timestamp = @sprintf("%04d-%02d-%02d-%02d-%02d-%02d", year(timestamp), month(timestamp), day(timestamp), hour(timestamp), minute(timestamp), second(timestamp))
        filename_of_db = filename_of_db[1:end-7] * "_$(formatted_timestamp).sqlite"
        println("Warning: This function requires to access a fresh database, therefore an own file $filename_of_db was reserved. The data will be stored there.")
    end

    # Create a new database connection
    db = SQLite.DB(filename_of_db)
    SQLite.execute(db, "CREATE TABLE sg (id INTEGER PRIMARY KEY, id_conj_class TEXT, meant_for_leftcoset_approach INTEGER, n INTEGER, subgrouporder INTEGER, subgroup_as_tuplelist STRING)")
    id_counter::Integer = 0
    id_conj_class_counter::Integer = 0


    if left_right_or_both in ["left", "both"]
        for (idx_alphabet_sym,n) in enumerate(range_of_alphabetsizes)
            G = symmetric_group(n)
            A = conjugacy_classes_subgroups(G)

            for a in A
                id_conj_class_counter += 1
                id_counter += 1

                subgroup_as_tuplelist = [Vector(el) for el in representative(a)]
                @assert length(subgroup_as_tuplelist) == Oscar.order(representative(a)) "These quantities should agree!" # delete later from code after several passes
                @assert check_right_dimensionality([[subgroup_as_tuplelist]], n) "FOR LEFTCOSET APPROACH: We have a problem with the subgroups generation, especially the representation as tuple!"

                if length(subgroup_as_tuplelist) in ordersconsidered[idx_alphabet_sym]
                    # Insert a row into the table
                    SQLite.execute(db, "INSERT INTO sg (id,id_conj_class,meant_for_leftcoset_approach,n,subgrouporder,subgroup_as_tuplelist) VALUES ($id_counter, $id_conj_class_counter, $(1), $n, $(length(subgroup_as_tuplelist)), '$subgroup_as_tuplelist')")
                end
            end
        end
    end


    if left_right_or_both in ["right", "both"]
        id_conj_class_counter = 0
        for n in range_of_alphabetsizes
            A = GAP.evalstr(""" n := $n; G:=SymmetricGroup(n); idprm := [];; for i in [1..n] do Add(idprm, i); od;
                                        CC:=ConjugacyClassesSubgroups(G);
                                        CCExpanded := [];;

                                        for cc in CC do
                                            if Order(cc[1]) in $(ordersconsidered[idx_alphabet_sym]) then
                                                M := [];;
                                                for sg in cc do
                                                    sg_casted := [];;
                                                    for el in sg do
                                                        if Length(ListPerm(el)) < 1 then
                                                            Add(sg_casted, idprm);
                                                        else
                                                            Add(sg_casted, ListPerm(el, $n));
                                                        fi;
                                                    od;
                                                    Add(M, AsList(sg_casted));
                                                od;
                                                Add(CCExpanded, M);
                                            fi;
                                        od;
                                        CCExpanded""")
            L = GAP.gap_to_julia(Vector{Vector{Vector{Vector{Int}}}}, A)
            @assert check_right_dimensionality(L, n) "FOR RIGHTCOSET APPROACH: We have a problem with the subgroups generation, especially the representation as tuple!"

            for clss in L
                id_conj_class_counter += 1
                for subgroup_as_tuplelist in clss
                    id_counter += 1
                    SQLite.execute(db, "INSERT INTO sg (id,id_conj_class,meant_for_leftcoset_approach,n,subgrouporder,subgroup_as_tuplelist) VALUES ($id_counter, $id_conj_class_counter, $(0), $n, $(length(subgroup_as_tuplelist)), '$subgroup_as_tuplelist')")
                end
            end
        end
    end
    SQLite.close(db)
end
