using Primes
using Dates, Printf, Statistics
using SQLite, DBInterface, DataFrames

"""
    E.g., ordered as in paper appendix:

    `    
    forconstellation_prepare__experiment_series("~/prestorage_subgroups_n_geq8_A.sqlite", "~/experiments_collection_n_geq8.sqlite", 1, 60, 6, 6, 3, [60, 30, 20, 15, 12, 10, 6], "glucose421", 3600)
    
    
    forconstellation_prepare__experiment_series("~/prestorage_subgroups_n_geq8_A.sqlite", "~/experiments_collection_n_geq8.sqlite", 1, 60, 6, 5, 3, [60, 30, 20, 15, 12, 10, 6], "glucose421", 3600)
    
    forconstellation_prepare__experiment_series("~/prestorage_subgroups_n_geq8_A.sqlite", "~/experiments_collection_n_geq8.sqlite", 1, 60, 5, 5, 3, [60], "glucose421", 3600)
    
    
    forconstellation_prepare__experiment_series("~/prestorage_subgroups_n_geq8_B.sqlite", "~/experiments_collection_n_geq8.sqlite", 1, 36, 8, 4, 3, [36, 18, 12, 9, 6, 4, 3, 2, 1], "glucose421", 3600)
    
    forconstellation_prepare__experiment_series("~/prestorage_subgroups_n_geq8_B.sqlite", "~/experiments_collection_n_geq8.sqlite", 1, 48, 8, 4, 3, [48, 24, 16, 12, 8, 6, 4, 3, 2, 1], "glucose421", 3600)    
    
    forconstellation_prepare__experiment_series("~/prestorage_subgroups_n_geq8_B.sqlite", "~/experiments_collection_n_geq8.sqlite", 1, 24, 8, 4, 3, [1], "glucose421", 3600)
    `    
"""
function forconstellation_prepare__experiment_series(groups_db_filename, target_db_filename, meant_for_leftcoset_approach, d, n, k, kappa, divisors, solver_employed, timelimit_per_run) # perhaps run in external file

    target_db = SQLite.DB(target_db_filename)
    table_name = "constellations" # Query to check if the table exists
    stmt = SQLite.Stmt(target_db, "SELECT name FROM sqlite_master WHERE type='table' AND name = '$table_name'")
    # Execute the query
    table_exists = DBInterface.execute(stmt)


    if isempty(table_exists)
        println("Table '$table_name' does not exist in the database. Creating the table now ...")
        SQLite.execute(target_db, "CREATE TABLE constellations (meant_for_leftcoset_approach INTEGER, d INTEGER, n INTEGER, k INTEGER, kappa INTEGER, subgrouporder INTEGER, subgroup_as_tuplelist STRING, offset_permutations STRING, pdesign_obtained STRING, solver_employed STRING, card_constraint_mode STRING, lex_strength INTEGER, timelimit_given REAL, solvertime_measured REAL, julias_tic_measured REAL,solver_report STRING, feasibility_check_passed INTEGER, solver_finished_in_time INTEGER, termination_status_experiment STRING, access_status STRING)")
    end

    SQLite.close(target_db)


    for divisor in divisors
        if d % divisor != 0
            println("Undivisibility! We were facing divisor $divisor for d=$d, n=$n, k=$k, kappa=$kappa ... Skipping experiment generation!")
            continue
        end
        # Open the database connection
        dbprep = SQLite.DB(groups_db_filename)

        # Execute a query to fetch data
        stmt = SQLite.Stmt(dbprep, "SELECT * FROM sg WHERE n=$n AND subgrouporder=$divisor AND meant_for_leftcoset_approach=$meant_for_leftcoset_approach")

        # Iterate over all rows of the fetched result



        db = SQLite.DB(target_db_filename)

        globcounter::Integer = 0
        for row in DBInterface.execute(stmt)
            globcounter += 1
            println("globcounter is $globcounter")

            SQLite.execute(db, "INSERT INTO constellations (meant_for_leftcoset_approach,d,n,k,kappa,subgrouporder,subgroup_as_tuplelist,offset_permutations, pdesign_obtained,solver_employed,card_constraint_mode,lex_strength,timelimit_given,solvertime_measured,julias_tic_measured, solver_report,feasibility_check_passed, solver_finished_in_time,termination_status_experiment,access_status) VALUES ($(row[:meant_for_leftcoset_approach]), $d, $(row[:n]), $k, $kappa, $(row[:subgrouporder]), '$(row[:subgroup_as_tuplelist])', NULL, NULL, '$(solver_employed)', '$("pysatCNF")', $(1000), $(timelimit_per_run), NULL, NULL,NULL, NULL, NULL, 'undefined', 'undefined')")
        end

        # Close the database connection
        SQLite.close(db)
        SQLite.close(dbprep)
    end
end

function all_divisors(n)
    d = [1]
    for (p, e) in Primes.factor(n)
        r = 1
        l = length(d)
        for i in 1:e
            r *= p
            for j in 1:l
                push!(d, d[j] * r)
            end
        end
    end
    return sort(d, rev=true) # not strictly required
end


function gen_all_subgroups_experims_given_card_alphabet_size_strength(PRESTORE_DB_PATH, TARGET_DB_PATH, d, n, k, kappa, solver_employed)
    forconstellation_prepare__experiment_series(PRESTORE_DB_PATH, TARGET_DB_PATH, 1, d, n, k, kappa, all_divisors(d), solver_employed, 3600)
    forconstellation_prepare__experiment_series(PRESTORE_DB_PATH, TARGET_DB_PATH, 0, d, n, k, kappa, [el for el in all_divisors(d) if el > 1], solver_employed, 3600)
end
